//---------------------------------------------------------------------------
/*=============================================================================}
{ This demo shows how to read information about items in RichView              }
{ Key methods and properties:                                                  }
{ - ItemCount,                                                                 }
{ - GetItemStyle,                                                              }
{ - GetTextInfo, GetBreakInfo, GetPictureInfo, GetControlInfo, GetBulletInfo,  }
{   GetHotspotInfo                                                             }
{ This demo also shows "hotspots"                                              }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TForm1::FillLeftRichView()
{
  RichView1->AddNL("Reading information about items",1,1);

  RichView1->AddBreakEx(2, rvbsLine, clRed);

  RichView1->AddNL("Image: ",0,0);
  Graphics::TBitmap* bmp = new Graphics::TBitmap;
  bmp->Width  = 60;
  bmp->Height = 40;
  bmp->Canvas->Pen->Color   = clRed;
  bmp->Canvas->Brush->Color = clYellow;
  bmp->Canvas->Rectangle(0,0,60,40);
  RichView1->AddPictureEx("Yellow box", bmp, -1, rvvaMiddle);

  RichView1->AddBreak();

  RichView1->AddNL("Bullet: ",0,0);
  RichView1->AddBulletEx("Printer image",0, ImageList1, -1);

  RichView1->AddBreak();

  RichView1->AddNL("Hotspot: ",0,0);
  RichView1->AddHotspotEx("Active printer image",1, 0, ImageList1, -1);
  RichView1->AddNL("(move mouse to hotspot and you see picture changes;"
          " more information about hotspots will be in hypertext description)",
          0,-1);

  RichView1->AddBreak();

  RichView1->AddNL("Button: ",0,0);
  TButton * btn = new TButton((TComponent*)NULL);
  btn->Width = 100;
  btn->Caption = "Out of order";
  RichView1->AddControlEx("Button example", btn, -1, rvvaBaseline);

  RichView1->Format();
}
//---------------------------------------------------------------------------
void GetBreakInfo(int ItemNo, TRichView* RichView1, TRichView* RichView2)
{
  unsigned char Width;
  TColor Color;
  TRVBreakStyle Style;
  int Tag;
  AnsiString ColorString;

  RichView1->GetBreakInfo(ItemNo, Width, Style, Color, Tag);
  if (Color == clNone)
    ColorString = "line has color of the 0-th text style";
  else
    ColorString = ColorToString(Color);
  RichView2->AddFmt("Item #%d: break. Color=%s; Width=%d",
                    ARRAYOFCONST((ItemNo, ColorString, (int)Width)), 0, 0);
  // Style is always rvbsLine in current version
}
//---------------------------------------------------------------------------
void GetPictureInfo(int ItemNo, TRichView* RichView1, TRichView* RichView2)
{
  TGraphic   *gr;
  TRVVAlign  VAlign;
  AnsiString VAString;
  AnsiString Name;
  int        Tag;

  RichView1->GetPictureInfo(ItemNo, Name, gr, VAlign, Tag);
  switch (VAlign)
  {
    case rvvaBaseline:
      VAString = "text base line";
      break;
    case rvvaMiddle:
      VAString = "text middle";
      break;
    default:
      VAString = "?";
  }

  RichView2->AddFmt("Item #%d: image (%s, %dx%d); Vertical alignment: %s; Name='%s'",
                    ARRAYOFCONST((ItemNo, AnsiString(gr->ClassName()), gr->Width, gr->Height, VAString, Name)),
                    0, 0);
}
//---------------------------------------------------------------------------
void GetControlInfo(int ItemNo, TRichView* RichView1, TRichView* RichView2)
{
  TControl*  ctrl;
  TRVVAlign  VAlign;
  AnsiString VAString;
  AnsiString Name;
  int        Tag;

  RichView1->GetControlInfo(ItemNo, Name, ctrl, VAlign, Tag);
  switch (VAlign)
  {
    case rvvaBaseline:
      VAString = "text base line";
      break;
    case rvvaMiddle:
      VAString = "text middle";
      break;
    default:
      VAString = "?";
  }
  RichView2->AddFmt("Item #%d: control (%s, %dx%d); Vertical alignment: %s; Name='%s'",
                    ARRAYOFCONST((ItemNo, AnsiString(ctrl->ClassName()), ctrl->Width, ctrl->Height, VAString, Name)),
                    0, 0);
}
//---------------------------------------------------------------------------
void GetBulletInfo(int ItemNo, TRichView* RichView1, TRichView* RichView2)
{
  TImageList* ImageList;
  AnsiString  Name;
  int         ImageIndex, Tag;

  RichView1->GetBulletInfo(ItemNo, Name, ImageIndex, ImageList, Tag);
  RichView2->AddFmt("Item #%d: bullet; ImageList='%s'; Image index=%d; Name='%s'",
                    ARRAYOFCONST((ItemNo, ImageList->Name, ImageIndex, Name)),
                    0, 0);
}
//---------------------------------------------------------------------------
void GetHotspotInfo(int ItemNo, TRichView* RichView1, TRichView* RichView2)
{
  TImageList* ImageList;
  AnsiString  Name;
  int         HotImageIndex, ImageIndex, Tag;

  RichView1->GetHotspotInfo(ItemNo, Name, ImageIndex, HotImageIndex, ImageList, Tag);
  RichView2->AddFmt("Item #%d: bullet; ImageList='%s'; Image index=%d, Hot image index=%d; Name='%s'",
                    ARRAYOFCONST((ItemNo, ImageList->Name, ImageIndex, HotImageIndex, Name)),
                    0, 0);
}
//---------------------------------------------------------------------------
void TForm1::FillRightRichView()
{
  int Tag;
  AnsiString s;
  // Reading information about items
  for (int i=0; i<RichView1->ItemCount; i++)
  {
    int ItemStyle = RichView1->GetItemStyle(i);
    if (ItemStyle>=0)
    {
      // Parameter of GetItemStyle - index of item (0..ItemCount).
      // If GetItemStyle returns zero or positive value,
      // this item is text, and returned value is an index in
      // collection of styles (RVStyle.TextStyles)
      RichView1->GetTextInfo(i, s, Tag);
      RichView2->AddFmt("Item #%d: text. Value='%s'. Style of text is '%s'",
                       ARRAYOFCONST((i, s, RVStyle1->TextStyles->Items[ItemStyle]->StyleName)),0,0);
    }
    else
      // If GetItemStyle returns negative value, this item is a non-text item
      switch (ItemStyle)
      {
        case rvsBreak:
          GetBreakInfo(i, RichView1, RichView2);
          break;
        case rvsPicture:
          GetPictureInfo(i, RichView1, RichView2);
          break;
        case rvsComponent:
          GetControlInfo(i, RichView1, RichView2);
          break;
        case rvsBullet:
          GetBulletInfo(i, RichView1, RichView2);
          break;
        case rvsHotspot:
          GetHotspotInfo(i, RichView1, RichView2);
          break;
        default:
          RichView2->AddNL("Unknown item type", 0, 0);
      }
    RichView2->AddBreak();
  }
  RichView2->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  FillLeftRichView();
  FillRightRichView();
}
//---------------------------------------------------------------------------
